#
#!/usr/bin/perl
# used for instance of object
#use Win32::OLE;
use Win32::OLE::Variant;
use strict;
#used for displaying time
use POSIX qw(strftime);

#********************************************************************************
#If you should have any comments, suggestions or improvements to these samples, 
#we welcome you to contact us at SampleCode@melissadata.com also please visit our 
#developers bulletin board at forum.melissadata.com.
#********************************************************************************


# ********************** LICENSE STRINGS ***********************
# *     To unlock the full functionality of Address Object,    *
# * please call a sales representative at 1-800-MELISSA ext. 3 * 
# *         (1-800-635-4772 x3) for a license string.          *
# *      Without a valid license string, AddressCheck will     *
# *                only verify Nevada addresses.               *
# **************************************************************
my $dLICENSE = "DEMO";

# ********************** DATA FILE PATH  ***********************
# File location path is set to the default Data File location. *
# Change this value if you installed the data files to a       *
# different folder.                                            *
# The Data Files Directory must contain the following files:   *
# mdAddr.dat and ZIPNPA.TXT.                                   *
# **************************************************************
my $dFILELOC = "C:\\Program Files\\Melissa DATA\\DQT\\Data";

#declare object

my $phoneObj = Win32::OLE->new('PhoneObject.PhoneCheck') or die "No PhoneOBject Found\n";

#declare scalar variables
my $Phone1;
my $Phone2;
my $Zip1;;
my $Zip2;
my $Latitude1;
my $Latitude2;
my $Longitude1;
my $Longitude2;
my $Results;

sub init_phoneObj{
	#initialize the object
	my $InitResult = $phoneObj->Initialize($dFILELOC);
	
	#Check Initialization
	if ($InitResult != 0)  # Initialization failed
	{
		printf $phoneObj->GetInitializeErrorString(), "\n";
		die "Cannot Initialize phoneObject";	
	}
	#set License
	$phoneObj->SetLicenseString($dLICENSE);
}
sub print_phone_head{
	print "========================================================================\n";
	print "Melissa Data PhoneObject PERL Sample\n";
	print "Build Number: ", $phoneObj->GetBuildNumber(), "\n";
	print "Initialize Status: ", $phoneObj->GetInitializeErrorString(), "\n";
	print "Database Date: ", $phoneObj->GetDatabaseDate(), "\n";
	print "========================================================================\n";
}
sub clear_screen{
	my $i;
 	for ($i=0; $i < 25; ++$i){
 	print "\n";
 	}
 }
sub get_input{
	#Take input of Zip and Phone separately
	print "Enter Phone 1 (ex 7028965154): ";
	$Phone1=<STDIN>;
	print "Enter Zip 1   (ex 89119)     : ";
	$Zip1=<STDIN>;

	
	#Take input of second Zip and Phone separately
	print "Enter Phone 2 (ex 7758268999): ";
	$Phone2=<STDIN>;
	print "Enter Zip 2   (ex 89509)     : ";
	$Zip2=<STDIN>;
}
sub output_Lookup{
	print "\n=== Lookup ====================================\n\n";
	print "AreaCode:         ", $phoneObj->{AreaCode},"\n";
	print "Latitude:         ", $phoneObj->{Latitude},"\n";
	print "Longitude:        ", $phoneObj->{Longitude},"\n";
	print "City:             ", $phoneObj->{City},"\n";
	print "State:            ", $phoneObj->{State},"\n";
	print "CountryCode:      ", $phoneObj->{CountryCode},"\n";
	print "CountyFips:       ", $phoneObj->{CountyFips},"\n";
	print "CountyName:       ", $phoneObj->{CountyName},"\n";
	print "Prefix:           ", $phoneObj->{Prefix},"\n";
	print "Suffix:           ", $phoneObj->{Suffix},"\n";
	print "Distance:         ", $phoneObj->{Distance},"\n";
	print "Extension:        ", $phoneObj->{Extension},"\n";
	print "MSA:              ", $phoneObj->{MSA},"\n";
	print "PMSA:             ", $phoneObj->{PMSA},"\n";
	print "TimeZone:         ", $phoneObj->{TimeZone},"\n";
	print "TimeZoneCode:     ", $phoneObj->{TimeZoneCode},"\n";
	$Results = $phoneObj->{Results};
	print "Results:          ", $Results,"\n";
	
	if ($Results =~ m/PE/i)
				{
					if ($Results =~ m/PE01/i)
					{
					   print "Area Code Not valid";
					}  
					if ($Results =~ m/PE02/i)
					{
					   print "Blank Phone Number";
					}  
					if ($Results =~ m/PE03/i)
					{
					   print "Phone Number Not valid";
					}  
					if ($Results =~ m/PE04/i)
					{
					   print "Input has Multiple Matches";
					}  
					if ($Results =~ m/PE05/i)
					{
					   print "Phone Prefix Not Valid";
					}  
					if ($Results =~ m/PE06/i)
					{
					   print "Zip Code Not Valid";
					}
				} 
	
	if (($Results =~ m/PS01/i) || ($Results =~ m/PS02/i))
	{ 
		if ($Results =~ m/PS01/i)
		{
          print "Phone validated to: 10 digits\n";
    }      
    elsif ($Results =~ m/PS02/i)
    {
          print "Phone validated to:  7 digits\n";
    }      
 
    if($Results =~ m/PS07/i)
    {
          print "     Exchange Type: Cellular\n";
    }      
    elsif($Results =~ m/PS08/i)
    {
          print "     Exchange Type: Land Line\n";
    }      
    elsif($Results =~ m/PS09/i)
    {
          print "     Exchange Type: Voip\n";
    }     
 
    if($Results =~ m/PS10/i)
    {
          print "        Phone Type: Residential\n";
    }     
    elsif ($Results =~ m/PS11/i)
    {
          print "        Phone Type: Business\n";
    }      
    elsif ($Results =~ m/PS12/i)
    {
          print "        Phone Type: Small/Home Office\n";
    }     
          
    if($Results =~ m/PS06/i) 
    {
    	  print "\n======New Area Code ======\n";
        print "AreaCode:         ", $phoneObj->{AreaCode},"\n";
        print "New Area Code: ", $phoneObj->{NewAreaCode},"\n";
    }     
		
	}
}
sub output_CorrectAreaCode{
	print "\n\n=== CorrectAreaCode ===========================\n\n";
	print "CorrectAreaCode:         ", $phoneObj->{NewAreaCode},"\n";
	print "Results:          ", $phoneObj->{Results},"\n";
	print "===============================================\n\n";
}


#Main
init_phoneObj();

#Clear screen
clear_screen();

#Print Details
print_phone_head();

#Get Input
get_input();

#Must typecast data before passing it through method
int $Zip1;
int $Phone1;

#Run Lookup Method
$phoneObj->Lookup($Phone1,$Zip1);
#Store Latitude and Longitude
$Latitude1=$phoneObj->{Latitude};
$Longitude1=$phoneObj->{Longitude};



#Print Results
print "\n\n===============================================\n\n";
print "Phone Number 1: ",$Phone1;
print "    Zip Code 1: ",$Zip1,"\n";

output_Lookup();
#Run Lookup Method
$phoneObj->CorrectAreaCode($Phone1,$Zip1);
output_CorrectAreaCode();

#Must typecast data before passing it through method
int $Zip2;
int $Phone2;

#Run Method on second zip
$phoneObj->Lookup($Phone2,$Zip2);
#Store Latitude and Longitude
$Latitude2=$phoneObj->{Latitude};
$Longitude2=$phoneObj->{Longitude};


#Print Results
print "Phone Number 2: ",$Phone2;
print "    Zip Code 2: ",$Zip2,"\n";

output_Lookup();
#Run Lookup Method
$phoneObj->CorrectAreaCode($Phone2,$Zip2);
output_CorrectAreaCode();


#Compute bearing from zips and Print Bearing results
print "Computed Bearing : ",$phoneObj->ComputeBearing($Latitude1,$Longitude1,$Latitude2,$Longitude2),"\n";
#Compute distance from zips and Print distance results
print "Computed Distance: ",$phoneObj->ComputeDistance($Latitude1,$Longitude1,$Latitude2,$Longitude2),"\n";
print "\n================================================\n\n";






